import { IParam, MainControlState } from "@core";

/**
 * @description 导航栏部件通讯对象
 * @export
 * @interface ExpBarControlState
 * @extends {MainControlState}
 */
export interface ExpBarControlState extends MainControlState {

  /**
   * @description 选中数据
   * @type {IParam}
   * @memberof ExpBarControlState
   */
  selection: IParam;

  /**
   * @description 分割栏绑定值
   * @type {number}
   * @memberof ExpBarControlState
   */
  split: number;

  /**
   * 导航视图标识
   *
   * @type {string}
   * @memberof ExpBarControlState
   */
  navViewName: string;

  /**
   * 导航过滤参数
   *
   * @type {string}
   * @memberof ExpBarControlState
   */
  navFilter?: string;

  /**
   * 导航关系
   *
   * @type {string}
   * @memberof ExpBarControlState
   */
  navPSDer?: string;

  /**
   * 导航上下文
   *
   * @type {IParam}
   * @memberof ExpBarControlState
   */
  navigateContext?: IParam;

  /**
   * 导航视图参数
   *
   * @type {IParam}
   * @memberof ExpBarControlState
   */
  navigateParams?: IParam;
}